%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: load_gasnames
%
% Scope:    read gas names from text file
%
% Input:    file name text file (string)
%           directory text file (string)
%
% Output:   updated "gasnames" string vector (cell)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function gasnames = load_gasnames(filename, pathname)
    fileID = fopen([pathname filename], 'r');
    
    % Initialize a cell array to store each line
    gasnames = {};
    
    % Read each line of the file until the end
    lineIndex = 1;
    while ~feof(fileID)
        % Read the next line from the file
        name = fgetl(fileID);
        name = strrep(name, ' ', '');
        % Store the line in the cell array
        gasnames{lineIndex} = string(name);
        
        % Move to the next index
        lineIndex = lineIndex + 1;
    end
    % Close the file
    fclose(fileID);
end
